# Toolffy Server

Backend API for the Toolffy application (Express + TypeScript).

## Overview

This repository contains the server-side application powering Toolffy. It provides authentication, product management, comments, notifications, and media handling, and is structured as modular features under `src/modules`.

## Quickstart

Prerequisites:

- Node 16+ and npm
- PostgreSQL (or the database configured in your environment)

1. Install dependencies

```bash
npm install
```

2. Create environment variables

Copy or create a `.env` file and provide the required variables (database URL, JWT secrets, cloud storage credentials, etc.). See the configuration files under `src/config` for the expected variables.

3. Run in development

```bash
npm run dev
```

4. Build and run

```bash
npm run build
npm start
```

## Common npm scripts

- `npm run dev` — run in development with hot reload
- `npm run build` — compile TypeScript
- `npm start` — run the compiled server

## Project layout

- `src/` — application source
  - `modules/` — feature modules (auth, account, product, etc.)
  - `config/` — configuration (database, cloudinary, passport)
  - `middlewares/` — Express middlewares
  - `utils/` — helper utilities

## Contributing

1. Create a feature branch
2. Open a pull request with a clear description and tests for new behavior

## License

This project includes a `LICENSE` file at the repository root.

---

If you want, I can expand this README with API docs, environment variable examples, or deployment steps (Vercel/Docker). Which would you like next?

# Complete Setup Guide backend with Node.js + TypeScript + Postgresql database

_ **1️⃣ Initialize Your Project**  
 _ mkdir my-backend  
 _ cd my-backend
_ npm init -y

CONSTRAINT account_upgrade_check CHECK (
account_type != 'company' OR
(account_type = 'company' AND is_email_verified = true)
)
