import dotenv from "dotenv";
import { Pool } from "pg";

dotenv.config({ path: ".env" });

// export const database = new Pool({
//   user: process.env.DB_USER,
//   host: process.env.DB_HOST,
//   database: process.env.DB_NAME,
//   password: process.env.DB_PASSWORD,
//   port: Number(process.env.DB_PORT),
//   max: 20,
//   idleTimeoutMillis: 30000,
// });

// async function connectToDatabase() {
//   try {
//     await database.connect();
//     console.log("✅ Connected to the database successfully");
//   } catch (error) {
//     console.error("❌ Database connnection failed:", error);
//     process.exit(1);
//   }
// }

// connectToDatabase();

export const database = new Pool({
  connectionString: process.env.DATABASE_URL,
  ssl: {
    rejectUnauthorized: false,
  },
  max: 20,
  idleTimeoutMillis: 30000,
});

(async () => {
  try {
    const client = await database.connect();
    console.log("✅ Connected to Neon PostgreSQL");
    client.release();
  } catch (error) {
    console.error("❌ Neon DB connection failed:", error);
    process.exit(1);
  }
})();

export default database;
