import database from "../../../config/db";

export async function createProductsProblemsSolutionsTable() {
  try {
    const tableQuery = `
        CREATE TABLE IF NOT EXISTS products_problem_solutions (
         id UUID DEFAULT gen_random_uuid() PRIMARY KEY,

         -- References 
         product_id UUID NOT NULL,


        -- Timestamps
         created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
         updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,

          -- Foreign key constraints
         FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE
        );`;

    await database.query(tableQuery);

    const indexes = [""];

    for (const indexQuery of indexes) {
      await database.query(indexQuery);
    }
  } catch (error) {
    console.error("❌ Failed To Create Product Benefit Table.", error);
    process.exit(1);
  }
}
