import database from "../../config/db";

export async function createProductsAnalyticsTable() {
  try {
    // Table creation
    const tableQuery = `
    CREATE TABLE IF NOT EXISTS product_analytics (
        id UUID DEFAULT gen_random_uuid() PRIMARY KEY,
        product_id UUID REFERENCES products(id),
        views INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT NOW()
    );`;

    await database.query(tableQuery);

    // console.log("✅ Products table created successfully");
  } catch (error) {
    console.error("❌ Failed To Create Products Table.", error);
    process.exit(1);
  }
}
