import express from "express";
import {
  removeAvatar,
  updateAvatar,
  getMyProfile,
  updateProfile,
  searchAccounts,
  getAccountStats,
  getPublicProfile,
  updateCoverImage,
  upgradeToCompany,
  removeCoverImage,
  deactivateAccount,
  reactivateAccount,
  updateAccountSettings,
  getAllAccounts,
  updateAccountStatus,
} from "./account.controller";
import { isAuthenticated, isUser, isCompany, isAdmin } from "../../middlewares/auth";

const router = express.Router();

// Public routes
router.get("/public/:identifier", getPublicProfile);
router.get("/search", searchAccounts);

// Protected routes (require authentication)
router.get("/me", isAuthenticated, getMyProfile);
router.put("/me", isAuthenticated, updateProfile);
router.put("/me/avatar", isAuthenticated, updateAvatar);
router.put("/me/cover-image", isAuthenticated, updateCoverImage);
router.delete("/me/avatar", isAuthenticated, removeAvatar);
router.delete("/me/cover-image", isAuthenticated, removeCoverImage);
router.put("/me/settings", isAuthenticated, updateAccountSettings);
router.post("/me/deactivate", isAuthenticated, deactivateAccount);
router.post("/me/stats", isAuthenticated, getAccountStats);

// Account type specific routes
router.post("/upgrade-to-company", isAuthenticated, isUser, upgradeToCompany);

// Admin/Moderator routes (we'll implement these later)
router.get("/admin/accounts", isAuthenticated, isAdmin, getAllAccounts);
router.put("/admin/accounts/:id/status", isAuthenticated, isAdmin, updateAccountStatus);

export default router;
