import express from "express";
import {
    getActivityFeed,
    createActivity,
    getProfileActivities,
    deleteActivity,
    updateActivityVisibility,
    getTrendingActivities,
} from "./activity.controller";
import { isAuthenticated } from "../../middlewares/auth";

const router = express.Router();

// Public routes
router.get("/trending", getTrendingActivities);
router.get("/profile/:account_id", getProfileActivities);

// Protected routes
router.get("/feed", isAuthenticated, getActivityFeed);
router.post("/", isAuthenticated, createActivity);
router.delete("/:activity_id", isAuthenticated, deleteActivity);
router.put("/:activity_id/visibility", isAuthenticated, updateActivityVisibility);

export default router;