import express from "express";
import {
    getAdminDashboard,
    getAllUsers,
    updateUserStatus,
    getSystemMetrics,
} from "./admin.controller";
import { isAuthenticated, hasPermission, hasMinLevel } from "../../middlewares/auth";

const router = express.Router();

// All admin routes require authentication and admin permissions
router.get("/dashboard", isAuthenticated, hasPermission("system.manage_settings"), getAdminDashboard);
router.get("/users", isAuthenticated, hasPermission("user.manage_roles"), getAllUsers);
router.put("/users/:user_id/status", isAuthenticated, hasPermission("user.manage_roles"), updateUserStatus);
router.get("/metrics", isAuthenticated, hasMinLevel(80), getSystemMetrics);

export default router;