import express from "express";
import {
  register,
  login,
  logout,
  verifyOtp,
  resendOtp,
  forgotPassword,
  resetPassword,
  updatePassword,
  checkUsername,
  checkEmail,
} from "./auth.controller";
import { isAuthenticated } from "../../middlewares/auth";

const router = express.Router();

// Public routes
router.post("/register", register);
router.post("/verify-otp", verifyOtp);
router.post("/resend-otp", resendOtp);
router.post("/login", login);
router.post("/password/forgot", forgotPassword);
router.put("/password/reset/:token", resetPassword);
router.get("/check-username", checkUsername);
router.get("/check-email", checkEmail);

// Protected routes
router.get("/logout", isAuthenticated, logout);
router.put("/password/update", isAuthenticated, updatePassword);

export default router;
  