

// export const socialLoginSuccess = (req: Request, res: Response) => {
//   // req.user is set by passport
//   const user = req.user as any;
//   if (!user) return res.redirect(`${process.env.FRONTEND_URL}/login`);
//   return generateToken(user, 200, "Logged in via social provider", res);
// };

// export const socialLogout = (req: Request, res: Response) => {
//   req.logout((err) => {
//     if (err) {
//       return res
//         .status(500)
//         .json({ success: false, messages: "Logout failed." });
//     }
//   });

//   // Alternative simpler logout without req.logout callback
//   res
//     .status(200)
//     .cookie("token", "", {
//       expires: new Date(Date.now()),
//       httpOnly: true,
//     })
//     .json({
//       success: true,
//       message: "Logged out successfully.",
//     });
// };


import { Request, Response } from "express";
import { generateToken } from "../../../utils/jwtToken";

export const socialLoginSuccess = (req: Request, res: Response) => {
  const user = req.user as any;
  if (!user) {
    return res.redirect(`${process.env.FRONTEND_URL}/login?error=social_login_failed`);
  }
  
  // Generate token and redirect to frontend with token
  const token = generateToken(user, 200, "Logged in via social provider", res);
  
  // Redirect to frontend with success message
  return res.redirect(`${process.env.FRONTEND_URL}/dashboard?login=success`);
};

export const socialLogout = (req: Request, res: Response) => {
  req.logout((err) => {
    if (err) {
      return res
        .status(500)
        .json({ success: false, message: "Logout failed." });
    }
    
    res
      .status(200)
      .clearCookie("access_token")
      .clearCookie("refresh_token")
      .json({
        success: true,
        message: "Logged out successfully.",
      });
  });
};