import express from "express";
import passport from "../../../config/passport";
import { socialLoginSuccess } from "./social.controller";

const router = express.Router();

// Google
router.get(
  "/google",
  passport.authenticate("google", { scope: ["profile", "email"] })
);

router.get(
  "/google/callback",
  passport.authenticate("google", {
    failureRedirect: `${process.env.FRONTEND_URL}/login`,
  }),
  socialLoginSuccess
);

// GitHub 
router.get(
  "/github",
  passport.authenticate("github", { scope: ["user:email"] })
);
router.get(
  "/github/callback",
  passport.authenticate("github", {
    failureRedirect: `${process.env.FRONTEND_URL}/login`,
  }),
  socialLoginSuccess
);

// LinkedIn
router.get("/linkedin", passport.authenticate("linkedin"));
router.get(
  "/linkedin/callback",
  passport.authenticate("linkedin", {
    failureRedirect: `${process.env.FRONTEND_URL}/login`,
  }),
  socialLoginSuccess
);

export default router;