import express from "express";
import { productSuggestedFeatureController } from "./product.suggested.feature.controller";
import {
  isAuthenticated,
  hasPermission,
  hasAnyPermission,
} from "../../middlewares/auth";

const router = express.Router();

// Public routes
router.get("/", productSuggestedFeatureController.getAllFeatureSuggestions);
router.get(
  "/search",
  productSuggestedFeatureController.searchFeatureSuggestions,
);
router.get(
  "/product/:productId",
  productSuggestedFeatureController.getProductFeatureSuggestions,
);
router.get(
  "/product/:productId/stats",
  productSuggestedFeatureController.getSuggestionStats,
);
router.get(
  "/product/:productId/top",
  productSuggestedFeatureController.getTopSuggestions,
);
router.get(
  "/product/:productId/status/:status",
  productSuggestedFeatureController.getSuggestionsByStatus,
);
router.get(
  "/product/:productId/roadmap",
  productSuggestedFeatureController.getProductRoadmap,
);
router.get(
  "/product/:productId/completed",
  productSuggestedFeatureController.getCompletedFeatures,
);
router.get("/:id", productSuggestedFeatureController.getFeatureSuggestionById);
router.get(
  "/:id/similar",
  productSuggestedFeatureController.getSimilarSuggestions,
);

// Protected routes - require authentication
router.post(
  "/",
  isAuthenticated,
  productSuggestedFeatureController.createFeatureSuggestion,
);

router.get(
  "/user/suggestions",
  isAuthenticated,
  productSuggestedFeatureController.getUserSuggestions,
);

router.get(
  "/user/voted",
  isAuthenticated,
  productSuggestedFeatureController.getUserVotedSuggestions,
);

router.get(
  "/:id/activity",
  isAuthenticated,
  productSuggestedFeatureController.getSuggestionActivity,
);

router.put(
  "/:id",
  isAuthenticated,
  productSuggestedFeatureController.updateFeatureSuggestion,
);

router.delete(
  "/:id",
  isAuthenticated,
  productSuggestedFeatureController.deleteFeatureSuggestion,
);

// Voting
router.post(
  "/:id/vote",
  isAuthenticated,
  productSuggestedFeatureController.voteOnFeatureSuggestion,
);

// Admin routes
router.post(
  "/bulk/update",
  isAuthenticated,
  hasPermission("suggestion:bulk_update"),
  productSuggestedFeatureController.bulkUpdateSuggestions,
);

export default router;
