import express from "express";
import {
    followAccount,
    unfollowAccount,
    acceptFollowRequest,
    rejectFollowRequest,
    blockFollower,
    unblockFollower,
    getFollowers,
    getFollowing,
    getFollowStats,
    checkFollowRelationship,
    getPendingFollowRequests,
} from "./follow.controller";
import { isAuthenticated } from "../../middlewares/auth";

const router = express.Router();

// Public routes
router.get("/:account_id/followers", getFollowers);
router.get("/:account_id/following", getFollowing);
router.get("/:account_id/stats", getFollowStats);

// Protected routes
router.post("/follow", isAuthenticated, followAccount);
router.delete("/unfollow/:following_id", isAuthenticated, unfollowAccount);
router.put("/request/accept/:follow_id", isAuthenticated, acceptFollowRequest);
router.put("/request/reject/:follow_id", isAuthenticated, rejectFollowRequest);
router.post("/block/:follower_id", isAuthenticated, blockFollower);
router.delete("/unblock/:follower_id", isAuthenticated, unblockFollower);
router.get("/relationship/:target_id", isAuthenticated, checkFollowRelationship);
router.get("/requests/pending", isAuthenticated, getPendingFollowRequests);

export default router;