import express from "express";
import {
    getNotifications,
    markNotificationAsRead,
    markAllNotificationsAsRead,
    deleteNotification,
    clearAllNotifications,
    updateNotificationSettings,
    getNotificationPreferences,
    createTestNotification,
} from "./notification.controller";
import { isAuthenticated } from "../../middlewares/auth";

const router = express.Router();

// All routes require authentication
router.get("/", isAuthenticated, getNotifications);
router.put("/:notification_id/read", isAuthenticated, markNotificationAsRead);
router.put("/read-all", isAuthenticated, markAllNotificationsAsRead);
router.delete("/:notification_id", isAuthenticated, deleteNotification);
router.delete("/", isAuthenticated, clearAllNotifications);
router.put("/settings/follow", isAuthenticated, updateNotificationSettings);
router.get("/preferences", isAuthenticated, getNotificationPreferences);
router.post("/test", isAuthenticated, createTestNotification);

export default router;