// utils/cleanupCron.ts
import cron from "node-cron";
import database from "../config/db";

export const setupCleanupCron = () => {
  // Run every hour
  cron.schedule("0 * * * *", async () => {
    try {
      console.log("Running cleanup cron job...");
      
      // Clean expired OTPs
      await database.query(
        `UPDATE accounts SET 
          otp_code = NULL,
          otp_expires_at = NULL
        WHERE otp_expires_at < CURRENT_TIMESTAMP`
      );
      
      // Clean expired reset tokens
      await database.query(
        `UPDATE accounts SET 
          reset_password_token = NULL,
          reset_password_expires_at = NULL
        WHERE reset_password_expires_at < CURRENT_TIMESTAMP`
      );
      
      console.log("Cleanup completed successfully");
    } catch (error) {
      console.error("Cleanup cron job failed:", error);
    }
  });
  
  console.log("Cleanup cron job scheduled to run every hour");
};