import axios from "axios";

export const verifyTurnstile = async (token: string, ip?: string) => {
  const response = await axios.post(
    "https://challenges.cloudflare.com/turnstile/v0/siteverify",
    new URLSearchParams({
      secret: process.env.TURNSTILE_SECRET_KEY!,
      response: token,
      ...(ip && { remoteip: ip }),
    }),
    {
      headers: {
        "Content-Type": "application/x-www-form-urlencoded",
      },
    }
  );

  return response.data; // { success: true/false }
};
