# Vercel Deployment Guide

Your project is now configured for deployment on Vercel. Here's how to deploy:

## Prerequisites
- Vercel account (sign up at https://vercel.com)
- Vercel CLI installed (already done: `npm install -g vercel`)

## Deployment Steps

### Option 1: Deploy via CLI (Recommended)

1. **Login to Vercel:**
   ```bash
   vercel login
   ```
   This will open a browser window to authenticate your Vercel account.

2. **Deploy your project:**
   ```bash
   vercel
   ```
   Follow the prompts:
   - Confirm the project directory (should be current directory)
   - Set project name (or use suggested)
   - Select scope (personal account or organization)

3. **Configure Environment Variables:**
   After deployment, go to Vercel dashboard → Project Settings → Environment Variables
   
   Add these environment variables from your `.env` file:
   - `PORT` (Vercel will set this automatically)
   - `FRONTEND_URL`
   - `DASHBOARD_URL`
   - `PORTFOLIO_URL`
   - Database credentials (if using external DB)
   - Email service credentials
   - Cloudinary credentials
   - OAuth credentials (Google, GitHub, Facebook, etc.)
   - Other sensitive data

### Option 2: Deploy via Git (GitHub/GitLab/Bitbucket)

1. Push your project to a Git repository
2. Go to https://vercel.com/new
3. Select your Git provider and authorize
4. Select your repository
5. Configure project settings if needed
6. Add environment variables in the dashboard
7. Click "Deploy"

## Post-Deployment

1. **Test your deployment:**
   - Visit the deployment URL provided by Vercel
   - Test all API endpoints
   - Verify Socket.io connections

2. **View logs:**
   ```bash
   vercel logs <deployment-url>
   ```

3. **Redeploy:**
   ```bash
   vercel --prod
   ```

## Important Notes

✅ **Already configured:**
- Build command: `npm run build`
- Output directory: `dist`
- Start command: `npm start`
- vercel.json updated with proper configuration
- .vercelignore created to exclude unnecessary files

⚠️ **Database:**
- Ensure your PostgreSQL database is accessible from Vercel (whitelist Vercel IPs)
- Consider using a cloud database service (PlanetScale, Neon, Supabase, etc.)

⚠️ **File Uploads:**
- Vercel has a 50MB request size limit
- For larger files, use cloud storage (Cloudinary is already configured)

⚠️ **WebSocket Support:**
- Socket.io works on Vercel with Node.js runtime
- Ensure clients connect to the correct deployment URL

## Troubleshooting

**Build fails:** Check npm output for TypeScript errors
**Environment variables not working:** Verify they're set in Vercel dashboard
**Database connection fails:** Check database is accessible from Vercel
**Port issues:** Vercel automatically assigns PORT, don't hardcode it
