import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { SendEmail } from "../schemas/schemas_0";
export { $Command };
export class SendEmailCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    EndpointId: { type: "contextParams", name: "EndpointId" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("SimpleEmailService_v2", "SendEmail", {})
    .n("SESv2Client", "SendEmailCommand")
    .sc(SendEmail)
    .build() {
}
