import { createBuildInPublicFeaturesSuggestTable } from "../migrations/product/suggestFeature/suggestFeature";
import { createProductsProblemsSolutionsTable } from "../migrations/product/introduction/problemSolutions";
import { createAlternativeProductTable } from "../migrations/product/alternative/alternativesProducts";
import { createProductsGallerysTable } from "../migrations/product/mediaGallery/galleryTable";
import { createProductsCategoriesTable } from "../migrations/product/productsCategoriesTable";
import { createProductsUpdatesTable } from "../migrations/product/update/productsUpdates";
import { createProductsUseCasesTable } from "../migrations/product/introduction/useCases";
import { createProductsReviewsTable } from "../migrations/product/review/productsReview";
import { createProductsCommentsTable } from "../migrations/product/productsComments";
import { createProductsTeamsTable } from "../migrations/product/team/productsTeams";
import { createNotificationsTable } from "../migrations/createNotificationsTable";
import { createProductsFaqsTable } from "../migrations/product/faq/productsFaqs";
import { createActivitiesTable } from "../migrations/createActivitiesTable";
import { createProductsTable } from "../migrations/product/productsTable";
import { createFollowsTable } from "../migrations/createFollowsTable";
import { createAccountsTable } from "../migrations/accountsTable";
import { createRolesTable } from "../migrations/rolesTable";
import { createContactTable } from "./contactTable";


export const createTables = async () => {
  try { 
    console.log("🔄 Creating database tables...");
    // Core Tables
    await createAccountsTable(); 
    await createRolesTable();
    await createFollowsTable();
    await createNotificationsTable();
    await createActivitiesTable();
    // Product Related Tables
    await createProductsCategoriesTable();
    await createProductsTable();
    await createProductsCommentsTable();
    await createProductsReviewsTable();
    await createProductsGallerysTable();
    await createProductsUpdatesTable();
    await createProductsFaqsTable();
    await createProductsTeamsTable();
    await createAlternativeProductTable();
    await createBuildInPublicFeaturesSuggestTable();
    // await createProductsUseCasesTable();
    // await createProductsProblemsSolutionsTable();

    await createContactTable();
    console.log("✅ All Tables Created Successfully.");
  } catch (error) {
    console.error("❌ Error creating tables:", error);
  }
};
 