import express from "express";
import { productFaqController } from "./product.faq.controller";
import {
  isAuthenticated,
  hasPermission,
  hasAnyPermission,
} from "../../middlewares/auth";

const router = express.Router();

// Public routes
router.get("/", productFaqController.getAllFaqs);
router.get("/search", productFaqController.searchFaqs);
router.get("/product/:productId", productFaqController.getProductFaqs);
router.get(
  "/product/:productId/categories",
  productFaqController.getProductFaqCategories,
);
router.get("/product/:productId/stats", productFaqController.getFaqStats);
router.get("/product/:productId/popular", productFaqController.getPopularFaqs);
router.get(
  "/product/:productId/category/:category",
  productFaqController.getFaqsByCategory,
);
router.get("/:id", productFaqController.getFaqById);
router.get("/slug/:slug", productFaqController.getFaqBySlug);
router.get("/:id/related", productFaqController.getRelatedFaqs);
router.post("/:id/click", productFaqController.incrementFaqClick);

// Protected routes - require authentication
router.post("/", isAuthenticated, productFaqController.createFaq);

router.get("/user/faqs", isAuthenticated, productFaqController.getUserFaqs);

router.put("/:id", isAuthenticated, productFaqController.updateFaq);

router.delete("/:id", isAuthenticated, productFaqController.deleteFaq);

// FAQ interactions
router.post(
  "/:id/helpful",
  isAuthenticated,
  productFaqController.markFaqHelpful,
);

// Bulk operations
router.post(
  "/bulk/update",
  isAuthenticated,
  hasPermission("faq:bulk_update"),
  productFaqController.bulkUpdateFaqs,
);

router.post(
  "/product/:productId/reorder",
  isAuthenticated,
  productFaqController.reorderFaqs,
);

export default router;
