import express from "express";
import { productController } from "./product.controller";

import {
  isAuthenticated,
  isAdmin,
  hasPermission,
  hasAnyPermission,
  canModifyResource,
} from "../../middlewares/auth";

const router = express.Router();

// Public routes
router.get("/", productController.getAllProducts);
router.get("/search", productController.searchProducts);
router.get("/trending", productController.getTrendingProducts);
router.get("/:id", productController.getProductById);
router.get("/slug/:slug", productController.getProductBySlug);
router.get("/creator/:creatorId", productController.getProductsByCreator);
router.get("/:id/stats", productController.getProductStats);
router.get("/:id/similar", productController.getSimilarProducts);

// Protected routes - require authentication
router.post(
  "/",
  isAuthenticated,
  // hasPermission("product:create"),
  productController.createProduct,
);

router.put(
  "/:id",
  isAuthenticated,
  // canModifyResource(
  //   "product",
  //   "product:update",
  //   "product:delete",
  //   "creator_id",
  // ),
  productController.updateProduct,
);

router.delete(
  "/:id",
  isAuthenticated,
  // canModifyResource(
  //   "product",
  //   "product:update",
  //   "product:delete",
  //   "creator_id",
  // ),
  productController.deleteProduct,
);

// Optional: Permanent delete route (admin only)
router.delete("/:id/permanent", productController.permanentlyDeleteProduct);

// Product interactions
router.post("/:id/upvote", isAuthenticated, productController.upvoteProduct);

router.post("/:id/follow", isAuthenticated, productController.followProduct);

// Admin only routes
router.post(
  "/:id/verify",
  isAuthenticated,
  // hasPermission("product:verify"),
  productController.verifyProduct,
);

router.put(
  "/:id/feature",
  isAuthenticated,
  // hasPermission("product:feature"),
  productController.featureProduct,
);

router.put(
  "/bulk/update",
  isAuthenticated,
  // hasPermission("product:bulk_update"),
  productController.bulkUpdateProducts,
);

export default router;
