import express from "express";
import { productCategoryController } from "./product.category.controller";
import { isAuthenticated, isAdmin, hasPermission } from "../../middlewares/auth";

const router = express.Router();

// Public routes
router.get("/", productCategoryController.getAllCategories);
router.get("/tree", productCategoryController.getCategoryTree);
router.get("/featured", productCategoryController.getFeaturedCategories);
router.get("/:id", productCategoryController.getCategoryById);
router.get("/slug/:slug", productCategoryController.getCategoryBySlug);

// Protected routes (Admin only)
router.post(
  "/",
  isAuthenticated,
  hasPermission("category:create"),
  productCategoryController.createCategory,
);

router.put(
  "/:id",
  isAuthenticated,
  hasPermission("category:update"),
  productCategoryController.updateCategory,
);

router.delete(
  "/:id",
  isAuthenticated,
  hasPermission("category:delete"),
  productCategoryController.deleteCategory,
);

router.put(
  "/bulk/update",
  isAuthenticated,
  hasPermission("category:update"),
  productCategoryController.bulkUpdateCategories,
);

export default router;
