export const generateEmailTemplate = (resetPasswordUrl: string) => {
  return `<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body style="margin: 0; padding: 0; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;">
  <table role="presentation" style="width: 100%; border-collapse: collapse;">
    <tr>
      <td align="center" style="padding: 40px 20px;">
        <!-- Main Container -->
        <table role="presentation" style="max-width: 700px; width: 100%; background: #ffffff; border-radius: 20px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); overflow: hidden;">
          
          <!-- Header with Gradient -->
          <tr>
            <td style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 25px 20px; text-align: center;">
              <h1 style="margin: 0; color: #ffffff; font-size: 28px; font-weight: 700; letter-spacing: -0.5px;">Password Reset Request</h1>
              <p style="margin: 10px 0 0; color: rgba(255,255,255,0.9); font-size: 16px;">Secure your account in just one click</p>
            </td>
          </tr>

          <!-- Content Section -->
          <tr>
            <td style="padding: 20px 40px 40px 30px;">
              <p style="margin: 0 0 10px; color: #2d3748; font-size: 18px; font-weight: 600;">Hello there! 👋</p>
              
              <p style="margin: 0 0 25px; color: #4a5568; font-size: 16px; line-height: 1.6;">
                We received a request to reset the password for your account. No worries - it happens to the best of us!
              </p>

              <p style="margin: 0 0 30px; color: #4a5568; font-size: 16px; line-height: 1;">
                Click the button below to create a new password:
              </p>

              <!-- CTA Button -->
              <table role="presentation" style="margin: 0 auto 30px; border-collapse: collapse;">
                <tr>
                  <td align="center" style="border-radius: 6px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);">
                    <a href="${resetPasswordUrl}" 
                       style="display: inline-block; padding: 12px 40px; color: #ffffff; text-decoration: none; font-size: 16px; font-weight: 600; letter-spacing: 0.5px; transition: all 0.3s ease;">
                      Reset My Password
                    </a>
                  </td>
                </tr>
              </table>

              <!-- Info Box -->
              <div style="background: #f7fafc; border-left: 4px solid #667eea; padding: 20px; border-radius: 8px; margin-bottom: 30px;">
                <p style="margin: 0 0 10px; color: #2d3748; font-size: 14px; font-weight: 600;">
                  ⏱️ Important Information
                </p>
                <p style="margin: 0; color: #4a5568; font-size: 14px; line-height: 1.6;">
                  This link will expire in <strong>15 minutes</strong> for security reasons. If you didn't request this reset, you can safely ignore this email.
                </p>
              </div>

              <!-- Alternative Link -->
              <p style="margin: 0 0 10px; color: #718096; font-size: 14px;">
                Button not working? Copy and paste this link:
              </p>
              <div style="background: #edf2f7; padding: 15px; border-radius: 8px; word-break: break-all;">
                <a href="${resetPasswordUrl}" style="color: #667eea; text-decoration: none; font-size: 13px;">
                  ${resetPasswordUrl}
                </a>
              </div>
            </td>
          </tr>

          <!-- Footer -->
          <tr>
            <td style="background: #f7fafc; padding: 30px 40px; text-align: center; border-top: 1px solid #e2e8f0;">
              <p style="margin: 0 0 10px; color: #2d3748; font-size: 16px; font-weight: 600;">
                Need help?
              </p>
              <p style="margin: 0 0 20px; color: #718096; font-size: 14px;">
                If you're having trouble, feel free to contact our support team.
              </p>
              
              <hr>

              <p style="margin: 20px 0 0; color: #a0aec0; font-size: 12px; line-height: 1.5;">
                This is an automated message, please do not reply to this email.<br>
                © ${new Date().getFullYear()} Your Portfolio. All rights reserved.
              </p>
            </td>
          </tr>

        </table>
      </td>
    </tr>
  </table>
</body>
</html>`;
};

export const resetEmailTemplate = (resetUrl: string) => {
  return `<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
      <h2 style="color: #333;">Password Reset Request</h2>
      <p>You requested to reset your password for your Toolffy account.</p>
      <p>Click the link below to reset your password:</p>
      <div style="margin: 25px 0;">
        <a href="${resetUrl}" style="background-color: #2b65f0; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; display: inline-block;">
          Reset Password
        </a>
      </div>
      <p style="color: #ff6b6b; font-size: 14px;">
        ⚠️ This link will expire in 15 minutes.
      </p>
      <p>If you didn't request this, please ignore this email.</p>
      <p style="color: #666; font-size: 12px; margin-top: 30px;">
        Or copy and paste this link in your browser:<br/>
        <span style="color: #2b65f0; word-break: break-all;">${resetUrl}</span>
      </p>
    </div>`;
};
