export const generateOtpEmailTemplate = (otp: string, accountType: string) => {
  const typeText = accountType === 'user' ? 'account' : 'company account';
  return `
    <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #e0e0e0; border-radius: 10px;">
      <div style="text-align: center; margin-bottom: 30px;">
        <h1 style="color: #2b65f0; margin: 0;">Toolffy</h1>
        <p style="color: #666; margin: 5px 0 20px;">Build in Public Platform</p>
      </div>
      
      <h2 style="color: #333; margin-bottom: 20px;">Verify Your ${typeText === 'company account' ? 'Company ' : ''}Email</h2>
      
      <p style="color: #555; line-height: 1.6; margin-bottom: 25px;">
        Thank you for registering with Toolffy! To complete your ${typeText} registration, 
        please use the following OTP (One-Time Password):
      </p>
      
      <div style="background-color: #f8f9fa; border: 2px dashed #2b65f0; border-radius: 8px; padding: 25px; text-align: center; margin: 25px 0;">
        <p style="color: #666; margin: 0 0 10px; font-size: 14px;">Your OTP code is:</p>
        <div style="font-size: 32px; font-weight: bold; color: #2b65f0; letter-spacing: 10px; margin: 10px 0;">
          ${otp}
        </div>
        <p style="color: #ff6b6b; margin: 10px 0 0; font-size: 13px;">
          ⚠️ Valid for 5 minutes only
        </p>
      </div>
      
      <p style="color: #555; line-height: 1.6; margin-bottom: 20px;">
        Enter this code on the verification page to complete your registration process.
      </p>
      
      <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #e0e0e0;">
        <p style="color: #999; font-size: 12px; margin: 5px 0;">
          If you didn't create an account with Toolffy, please ignore this email.
        </p>
        <p style="color: #999; font-size: 12px; margin: 5px 0;">
          This is an automated email, please do not reply.
        </p>
      </div>
    </div>
  `;
};